#!/bin/bash

echo "========================================"
echo "   ZZMaps API Client - Upload Data"
echo "========================================"
echo

# Check if Node.js is installed
if ! command -v node &> /dev/null; then
    echo "ERROR: Node.js is not installed!"
    echo "Please install Node.js from https://nodejs.org"
    exit 1
fi

# Check if dependencies are installed
if [ ! -d "node_modules" ]; then
    echo "Dependencies not installed. Running install..."
    ./install.sh
    if [ $? -ne 0 ]; then
        echo "ERROR: Installation failed!"
        exit 1
    fi
fi

# Check if .env file exists
if [ ! -f .env ]; then
    echo ".env file not found. Running setup..."
    npm run setup
    if [ $? -ne 0 ]; then
        echo "ERROR: Setup failed!"
        exit 1
    fi
fi

echo
echo "Starting data upload..."
echo

# Run upload
npm run upload-current
if [ $? -ne 0 ]; then
    echo "ERROR: Upload failed!"
    exit 1
fi

echo
echo "========================================"
echo "   Upload completed successfully!"
echo "========================================"
echo
read -p "Press any key to continue..."
