#!/bin/bash

echo "========================================"
echo "   ZZMaps API Client - Quick Run"
echo "========================================"
echo

# Check if Node.js is installed
if ! command -v node &> /dev/null; then
    echo "ERROR: Node.js is not installed!"
    echo "Please install Node.js from https://nodejs.org"
    exit 1
fi

# Check if dependencies are installed
if [ ! -d "node_modules" ]; then
    echo "Dependencies not installed. Running install..."
    ./install.sh
    if [ $? -ne 0 ]; then
        echo "ERROR: Installation failed!"
        exit 1
    fi
fi

# Check if .env file exists
if [ ! -f .env ]; then
    echo ".env file not found. Running setup..."
    npm run setup
    if [ $? -ne 0 ]; then
        echo "ERROR: Setup failed!"
        exit 1
    fi
fi

echo
echo "Starting ZZMaps API Client..."
echo

# Show menu
while true; do
    echo "========================================"
    echo "   ZZMaps API Client - Main Menu"
    echo "========================================"
    echo
    echo "1. Upload all data"
    echo "2. Interactive menu"
    echo "3. Demo project"
    echo "4. Setup project"
    echo "5. Exit"
    echo

    read -p "Enter your choice (1-5): " choice

    case $choice in
        1)
            echo
            echo "Starting upload..."
            npm run upload-current
            echo
            echo "Upload completed!"
            read -p "Press any key to continue..."
            ;;
        2)
            echo
            echo "Starting interactive menu..."
            npm start
            ;;
        3)
            echo
            echo "Running demo..."
            node scripts/demo.js
            echo
            read -p "Press any key to continue..."
            ;;
        4)
            echo
            echo "Running setup..."
            npm run setup
            echo
            read -p "Press any key to continue..."
            ;;
        5)
            echo
            echo "Goodbye!"
            exit 0
            ;;
        *)
            echo "Invalid choice. Please try again."
            ;;
    esac
done
