@echo off
echo ========================================
echo    ZZMaps API Client - Quick Run
echo ========================================
echo.

REM Check if Node.js is installed
node --version >nul 2>&1
if %errorlevel% neq 0 (
    echo ERROR: Node.js is not installed!
    echo Please install Node.js from https://nodejs.org
    pause
    exit /b 1
)

REM Check if dependencies are installed
if not exist node_modules (
    echo Dependencies not installed. Running install...
    call install.bat
    if %errorlevel% neq 0 (
        echo ERROR: Installation failed!
        pause
        exit /b 1
    )
)

REM Check if .env file exists
if not exist .env (
    echo .env file not found. Running setup...
    call npm run setup
    if %errorlevel% neq 0 (
        echo ERROR: Setup failed!
        pause
        exit /b 1
    )
)

echo.
echo Starting ZZMaps API Client...
echo.

REM Show menu
:menu
echo ========================================
echo    ZZMaps API Client - Main Menu
echo ========================================
echo.
echo 1. Upload all data
echo 2. Interactive menu
echo 3. Demo project
echo 4. Setup project
echo 5. Exit
echo.

set /p choice="Enter your choice (1-5): "

if "%choice%"=="1" (
    echo.
    echo Starting upload...
    call npm run upload-current
    echo.
    echo Upload completed!
    pause
    goto menu
)

if "%choice%"=="2" (
    echo.
    echo Starting interactive menu...
    call npm start
    goto menu
)

if "%choice%"=="3" (
    echo.
    echo Running demo...
    call node scripts/demo.js
    echo.
    pause
    goto menu
)

if "%choice%"=="4" (
    echo.
    echo Running setup...
    call npm run setup
    echo.
    pause
    goto menu
)

if "%choice%"=="5" (
    echo.
    echo Goodbye!
    exit /b 0
)

echo Invalid choice. Please try again.
goto menu
