const config = {
  // API Configuration
  api: {
    baseUrl: 'https://api.zzmaps.com',
    version: 'v1',
    timeout: 30000, // 30 seconds
    retryAttempts: 3,
    retryDelay: 1000 // 1 second
  },
  
  // Authentication
  auth: {
    username: process.env.ZZMAPS_USERNAME || '',
    password: process.env.ZZMAPS_PASSWORD || '',
    apiKey: process.env.ZZMAPS_API_KEY || ''
  },
  
  // Upload Configuration
  upload: {
    chunkSize: 1024 * 1024, // 1MB chunks
    maxConcurrentUploads: 3,
    supportedFormats: ['.fbl', '.fjv', '.fpa', '.fda', '.poi', '.3dc', '.3dl', '.spc', '.spud'],
    maxFileSize: 500 * 1024 * 1024 // 500MB max file size
  },
  
  // Data paths
  paths: {
    mapData: '../map',
    poiData: '../poi',
    buildingData: '../building',
    speedcamData: '../speedcam',
    tempDir: './temp',
    backupDir: './backup'
  },
  
  // Logging
  logging: {
    level: 'info',
    file: './logs/upload.log',
    maxSize: '10MB',
    maxFiles: 5
  }
};

module.exports = config;
