const path = require('path');
const config = require('./config');

// Override paths to point to the current map data directory
const localConfig = {
  ...config,
  paths: {
    ...config.paths,
    // Point to the parent directory where map data is located
    mapData: path.resolve(__dirname, '../../map'),
    poiData: path.resolve(__dirname, '../../poi'),
    buildingData: path.resolve(__dirname, '../../building'),
    speedcamData: path.resolve(__dirname, '../../speedcam'),
    tempDir: path.resolve(__dirname, '../temp'),
    backupDir: path.resolve(__dirname, '../backup')
  }
};

module.exports = localConfig;
