# 📤 Hướng dẫn upload lên File Manager

## 🎯 **Tại sao cần upload lên File Manager:**

- ✅ **Không cần SSH** - Chỉ cần file manager
- ✅ **Không cần quyền root** - Upload qua web interface
- ✅ **Dễ quản lý** - Sử dụng giao diện web
- ✅ **An toàn** - Không cần truy cập server

## 🚀 **Cách upload siêu đơn giản:**

### **Bước 1: Chuẩn bị file**
1. **Nén toàn bộ thư mục** `zzmaps-api-project` thành file ZIP
2. **Đặt tên file** là `zzmaps-api-project.zip`
3. **Kiểm tra kích thước** file ZIP (khoảng 50-100MB)

### **Bước 2: Upload lên File Manager**
1. **Đăng nhập** vào cPanel hoặc hosting control panel
2. **Mở File Manager** hoặc quản lý file
3. **Di chuyển** đến thư mục `public_html` hoặc `www`
4. **Upload file** `zzmaps-api-project.zip`
5. **Chờ upload** hoàn tất

### **Bước 3: Giải nén file**
1. **Click chuột phải** vào file ZIP
2. **Chọn "Extract"** hoặc "Giải nén"
3. **Chọn thư mục** để giải nén (thường là `public_html`)
4. **Click "Extract"** để giải nén
5. **Xóa file ZIP** sau khi giải nén xong

### **Bước 4: Kiểm tra cấu trúc thư mục**
Sau khi giải nén, bạn sẽ thấy:
```
public_html/
└── zzmaps-api-project/
    ├── install.php
    ├── package.json
    ├── src/
    ├── scripts/
    ├── config/
    └── ...
```

## 🎮 **Sử dụng 1-Click Install:**

### **Bước 1: Truy cập URL**
1. **Mở trình duyệt** và truy cập: `https://yourdomain.com/zzmaps-api-project/install.php`
2. **Thay thế** `yourdomain.com` bằng domain thực tế của bạn
3. **Ví dụ**: `https://api.zzmaps.com/zzmaps-api-project/install.php`

### **Bước 2: Cài đặt tự động**
1. **Xem trạng thái** dự án trong giao diện
2. **Click "Cài đặt Node.js"** (nếu chưa có)
3. **Click "Cài đặt Dependencies"**
4. **Click "Tạo file cấu hình"**
5. **Click "Chạy Setup"** và nhập API credentials
6. **Click "Upload dữ liệu"** để upload 461MB dữ liệu

## 🔧 **Cấu hình cho File Manager:**

### **1. Yêu cầu hosting:**
- ✅ **PHP 7.4+** - Để chạy script cài đặt
- ✅ **Node.js support** - Để chạy dự án
- ✅ **Shell access** - Để chạy lệnh terminal
- ✅ **File manager** - Để upload dự án

### **2. Cấu hình PHP:**
```php
// Cấu hình trong .htaccess
php_value max_execution_time 300
php_value memory_limit 256M
php_value upload_max_filesize 500M
php_value post_max_size 500M
```

### **3. Cấu hình Node.js:**
```bash
# Cài đặt Node.js 18.x (LTS)
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs
```

## 📁 **Cấu trúc file sau khi upload:**

```
public_html/
├── zzmaps-api-project/
│   ├── install.php              # File 1-click install
│   ├── package.json             # Dependencies
│   ├── src/                     # Mã nguồn
│   │   ├── models/
│   │   ├── services/
│   │   └── index.js
│   ├── scripts/                 # Scripts
│   │   ├── upload-data.js
│   │   ├── sync-data.js
│   │   └── demo.js
│   ├── config/                  # Cấu hình
│   │   ├── config.js
│   │   └── config-local.js
│   ├── node_modules/            # Dependencies (sau khi cài đặt)
│   └── .env                     # API credentials (sau khi tạo)
└── export_maps_signs/           # Dữ liệu bản đồ
    ├── map/
    ├── poi/
    ├── building/
    └── speedcam/
```

## 🎯 **Lợi ích của File Manager:**

### **1. Dễ sử dụng:**
- Giao diện web thân thiện
- Không cần kiến thức kỹ thuật
- Upload và quản lý file dễ dàng

### **2. An toàn:**
- Không cần quyền SSH
- Không cần quyền root
- Chạy qua web browser

### **3. Tiện lợi:**
- Có thể truy cập từ bất kỳ đâu
- Không cần cài đặt phần mềm
- Quản lý file trực quan

## 🆘 **Troubleshooting:**

### **Lỗi "File too large":**
- Chia nhỏ file ZIP thành nhiều phần
- Sử dụng FTP client thay vì file manager
- Liên hệ hosting provider để tăng giới hạn upload

### **Lỗi "Permission denied":**
- Kiểm tra quyền truy cập file
- Sử dụng file manager để cấp quyền
- Liên hệ hosting provider để cấp quyền

### **Lỗi "Extract failed":**
- Kiểm tra file ZIP có bị hỏng không
- Thử giải nén bằng phần mềm khác
- Upload lại file ZIP

### **Lỗi "Node.js not found":**
- Kiểm tra hosting có hỗ trợ Node.js không
- Liên hệ hosting provider để cài đặt Node.js
- Sử dụng script cài đặt Node.js trong giao diện

## 🚀 **Sau khi upload xong:**

1. **Truy cập URL** `install.php` để cài đặt tự động
2. **Dữ liệu được upload** lên api.zzmaps.com
3. **Website api.zzmaps.com** có thể sử dụng dữ liệu
4. **Ứng dụng mobile** kết nối trực tiếp với API

## 🎉 **Tóm tắt:**

- ✅ **File Manager** hoàn hảo cho shared hosting
- ✅ **Không cần SSH** hay quyền root
- ✅ **Upload và giải nén** dễ dàng
- ✅ **1-Click Install** tự động hóa hoàn toàn
- ✅ **Chỉ cần upload và click** là xong

---

**🚀 BẮT ĐẦU NGAY: Upload dự án lên File Manager và truy cập `install.php`!**
