# 🐧🌐 Ubuntu 24.04 + Shared Hosting - Hướng dẫn hoàn chỉnh

## 🎯 **Tại sao Ubuntu 24.04 + Shared Hosting hoàn hảo:**

- ✅ **Ubuntu 24.04** - Hệ điều hành ổn định và bảo mật
- ✅ **Shared Hosting** - Chi phí thấp, không cần quyền root
- ✅ **Node.js support** - Hỗ trợ tốt cho JavaScript
- ✅ **Dễ quản lý** - Không cần cấu hình phức tạp

## 🚀 **Cài đặt siêu đơn giản:**

### **Cách 1: Sử dụng script tự động (Khuyến nghị)**
```bash
# Cấp quyền thực thi
chmod +x shared-hosting.sh install-ubuntu.sh

# Chạy script cho shared hosting
./shared-hosting.sh

# Hoặc chạy script cho Ubuntu thông thường
./install-ubuntu.sh
```

### **Cách 2: Cài đặt thủ công**
```bash
# Cập nhật package list
sudo apt update

# Cài đặt Node.js và npm
sudo apt install nodejs npm

# Kiểm tra cài đặt
node --version
npm --version

# Cài đặt dependencies
npm install

# Chạy setup
npm run setup
```

## 🎮 **Sử dụng dự án:**

### **Upload dữ liệu:**
```bash
# Upload tất cả dữ liệu
./upload.sh

# Hoặc sử dụng npm
npm run upload-current
```

### **Menu tương tác:**
```bash
# Chạy menu chính
./run.sh

# Hoặc sử dụng npm
npm start
```

### **Demo dự án:**
```bash
# Xem thông tin dự án
./demo.sh

# Hoặc sử dụng npm
node scripts/demo.js
```

## 🔧 **Cấu hình cho Ubuntu 24.04:**

### **1. Cài đặt Node.js:**
```bash
# Cài đặt phiên bản LTS
sudo apt install nodejs npm

# Kiểm tra phiên bản
node --version  # Should be v18.x or higher
npm --version   # Should be v9.x or higher
```

### **2. Cấu hình npm:**
```bash
# Cấu hình npm để sử dụng global packages
mkdir ~/.npm-global
npm config set prefix '~/.npm-global'
echo 'export PATH=~/.npm-global/bin:$PATH' >> ~/.bashrc
source ~/.bashrc
```

### **3. Cấu hình firewall:**
```bash
# Mở port cho API (nếu cần)
sudo ufw allow 3000
sudo ufw allow 8080
```

## 🌐 **Cấu hình cho Shared Hosting:**

### **1. Cài đặt Node.js:**
```bash
# Cài đặt Node.js 18.x (LTS)
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs

# Kiểm tra cài đặt
node --version  # Should be v18.x or higher
npm --version   # Should be v9.x or higher
```

### **2. Cấu hình npm:**
```bash
# Cấu hình npm để sử dụng thư mục user
mkdir ~/.npm-global
npm config set prefix '~/.npm-global'
echo 'export PATH=~/.npm-global/bin:$PATH' >> ~/.bashrc
source ~/.bashrc
```

## 📁 **Cấu trúc thư mục:**

```
/home/username/
├── zzmaps-api-project/
│   ├── shared-hosting.sh       # Script cho shared hosting
│   ├── install-ubuntu.sh       # Script cho Ubuntu
│   ├── install.sh              # Script cài đặt chung
│   ├── run.sh                  # Menu chính
│   ├── upload.sh               # Upload dữ liệu
│   ├── demo.sh                 # Demo dự án
│   ├── src/                    # Mã nguồn
│   ├── scripts/                # Scripts
│   ├── config/                 # Cấu hình
│   ├── node_modules/           # Dependencies
│   └── .env                    # API credentials
└── export_maps_signs/          # Dữ liệu bản đồ
    ├── map/
    ├── poi/
    ├── building/
    └── speedcam/
```

## 🎯 **Lợi ích khi sử dụng Ubuntu 24.04 + Shared Hosting:**

### **1. Hiệu suất cao:**
- Ubuntu 24.04 được tối ưu cho Node.js
- Hỗ trợ đa luồng tốt
- Quản lý memory hiệu quả

### **2. Chi phí thấp:**
- Chỉ cần shared hosting cơ bản
- Không cần VPS đắt tiền
- Không cần quản lý server

### **3. Bảo mật:**
- Ubuntu LTS được hỗ trợ lâu dài
- Cập nhật bảo mật thường xuyên
- Firewall tích hợp

### **4. Dễ quản lý:**
- Package manager apt mạnh mẽ
- Logs chi tiết
- Monitoring tools sẵn có

## 🆘 **Troubleshooting:**

### **Lỗi "Permission denied":**
```bash
# Cấp quyền thực thi
chmod +x *.sh

# Chạy với quyền user
./shared-hosting.sh
```

### **Lỗi "Node.js not found":**
```bash
# Cài đặt Node.js
sudo apt update
sudo apt install nodejs npm

# Hoặc sử dụng NodeSource
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs
```

### **Lỗi "npm not found":**
```bash
# Cài đặt npm
sudo apt install npm

# Hoặc cài đặt Node.js (bao gồm npm)
sudo apt install nodejs npm
```

### **Lỗi "EACCES" khi cài đặt packages:**
```bash
# Cấu hình npm để sử dụng thư mục user
mkdir ~/.npm-global
npm config set prefix '~/.npm-global'
echo 'export PATH=~/.npm-global/bin:$PATH' >> ~/.bashrc
source ~/.bashrc
```

## 🚀 **Sau khi cài đặt xong:**

1. **Dữ liệu được upload** lên api.zzmaps.com
2. **Website api.zzmaps.com** có thể sử dụng dữ liệu
3. **Ứng dụng mobile** kết nối trực tiếp với API
4. **Không cần server riêng** để chạy ứng dụng

## 🎉 **Tóm tắt:**

- ✅ **Ubuntu 24.04** hoàn hảo cho dự án này
- ✅ **Shared Hosting** chi phí thấp và dễ quản lý
- ✅ **Không cần quyền root** để chạy
- ✅ **Hiệu suất cao** và ổn định
- ✅ **Hỗ trợ Node.js** sẵn có

---

**🚀 BẮT ĐẦU NGAY: Chạy `./shared-hosting.sh` để cài đặt và upload dữ liệu!**
