@echo off
echo ========================================
echo    ZZMaps API Client - Upload Data
echo ========================================
echo.

REM Check if Node.js is installed
node --version >nul 2>&1
if %errorlevel% neq 0 (
    echo ERROR: Node.js is not installed!
    echo Please install Node.js from https://nodejs.org
    pause
    exit /b 1
)

REM Check if dependencies are installed
if not exist node_modules (
    echo Dependencies not installed. Running install...
    call install.bat
    if %errorlevel% neq 0 (
        echo ERROR: Installation failed!
        pause
        exit /b 1
    )
)

REM Check if .env file exists
if not exist .env (
    echo .env file not found. Running setup...
    call npm run setup
    if %errorlevel% neq 0 (
        echo ERROR: Setup failed!
        pause
        exit /b 1
    )
)

echo.
echo Starting data upload...
echo.

REM Run upload
call npm run upload-current
if %errorlevel% neq 0 (
    echo ERROR: Upload failed!
    pause
    exit /b 1
)

echo.
echo ========================================
echo    Upload completed successfully!
echo ========================================
echo.
echo Press any key to continue...
pause >nul
