# 🐧 Hướng dẫn sử dụng trên Ubuntu 24.04

## 🎯 **Tại sao Ubuntu 24.04 hoàn hảo cho dự án này:**

- ✅ **Hỗ trợ Node.js tốt** - Ubuntu có package Node.js chính thức
- ✅ **Không cần quyền root** - Chỉ cần quyền user thường
- ✅ **Shared hosting friendly** - Chạy được trên shared hosting
- ✅ **Ổn định và bảo mật** - Ubuntu LTS được hỗ trợ lâu dài

## 🚀 **Cài đặt siêu đơn giản:**

### **Cách 1: Sử dụng script tự động (Khuyến nghị)**
```bash
# Cấp quyền thực thi
chmod +x install-ubuntu.sh

# Chạy script cài đặt
./install-ubuntu.sh
```

### **Cách 2: Cài đặt thủ công**
```bash
# Cập nhật package list
sudo apt update

# Cài đặt Node.js và npm
sudo apt install nodejs npm

# Kiểm tra cài đặt
node --version
npm --version

# Cài đặt dependencies
npm install

# Chạy setup
npm run setup
```

## 🎮 **Sử dụng dự án:**

### **Upload dữ liệu:**
```bash
# Upload tất cả dữ liệu
./upload.sh

# Hoặc sử dụng npm
npm run upload-current
```

### **Menu tương tác:**
```bash
# Chạy menu chính
./run.sh

# Hoặc sử dụng npm
npm start
```

### **Demo dự án:**
```bash
# Xem thông tin dự án
./demo.sh

# Hoặc sử dụng npm
node scripts/demo.js
```

## 🔧 **Cấu hình cho Ubuntu:**

### **1. Cài đặt Node.js:**
```bash
# Cài đặt phiên bản LTS
sudo apt install nodejs npm

# Kiểm tra phiên bản
node --version  # Should be v18.x or higher
npm --version   # Should be v9.x or higher
```

### **2. Cấu hình npm (tùy chọn):**
```bash
# Cấu hình npm để sử dụng global packages
mkdir ~/.npm-global
npm config set prefix '~/.npm-global'
echo 'export PATH=~/.npm-global/bin:$PATH' >> ~/.bashrc
source ~/.bashrc
```

### **3. Cấu hình firewall (nếu cần):**
```bash
# Mở port cho API (nếu cần)
sudo ufw allow 3000
sudo ufw allow 8080
```

## 📁 **Cấu trúc thư mục trên Ubuntu:**

```
/home/username/
├── zzmaps-api-project/
│   ├── install-ubuntu.sh      # Script cài đặt cho Ubuntu
│   ├── install.sh             # Script cài đặt chung
│   ├── run.sh                 # Menu chính
│   ├── upload.sh              # Upload dữ liệu
│   ├── demo.sh                # Demo dự án
│   ├── src/                   # Mã nguồn
│   ├── scripts/               # Scripts
│   ├── config/                # Cấu hình
│   ├── node_modules/          # Dependencies
│   └── .env                   # API credentials
└── export_maps_signs/         # Dữ liệu bản đồ
    ├── map/
    ├── poi/
    ├── building/
    └── speedcam/
```

## 🎯 **Lợi ích khi sử dụng Ubuntu:**

### **1. Hiệu suất cao:**
- Ubuntu 24.04 được tối ưu cho Node.js
- Hỗ trợ đa luồng tốt
- Quản lý memory hiệu quả

### **2. Bảo mật:**
- Cập nhật bảo mật thường xuyên
- Hỗ trợ LTS (Long Term Support)
- Firewall tích hợp

### **3. Dễ quản lý:**
- Package manager apt mạnh mẽ
- Logs chi tiết
- Monitoring tools sẵn có

## 🆘 **Troubleshooting trên Ubuntu:**

### **Lỗi "Permission denied":**
```bash
# Cấp quyền thực thi
chmod +x *.sh

# Chạy với quyền user
./install-ubuntu.sh
```

### **Lỗi "Node.js not found":**
```bash
# Cài đặt Node.js
sudo apt update
sudo apt install nodejs npm

# Kiểm tra PATH
echo $PATH
which node
```

### **Lỗi "npm not found":**
```bash
# Cài đặt npm
sudo apt install npm

# Hoặc cài đặt Node.js (bao gồm npm)
sudo apt install nodejs npm
```

### **Lỗi "EACCES" khi cài đặt packages:**
```bash
# Cấu hình npm để sử dụng thư mục user
mkdir ~/.npm-global
npm config set prefix '~/.npm-global'
echo 'export PATH=~/.npm-global/bin:$PATH' >> ~/.bashrc
source ~/.bashrc
```

## 🚀 **Sau khi cài đặt xong:**

1. **Dữ liệu được upload** lên api.zzmaps.com
2. **Website api.zzmaps.com** có thể sử dụng dữ liệu
3. **Ứng dụng mobile** kết nối trực tiếp với API
4. **Không cần server riêng** để chạy ứng dụng

## 🎉 **Tóm tắt:**

- ✅ **Ubuntu 24.04** hoàn hảo cho dự án này
- ✅ **Không cần quyền root** để chạy
- ✅ **Shared hosting friendly**
- ✅ **Hiệu suất cao và ổn định**
- ✅ **Dễ quản lý và bảo trì**

---

**🚀 BẮT ĐẦU NGAY: Chạy `./install-ubuntu.sh` để cài đặt và upload dữ liệu!**
