class MapData {
  constructor(data) {
    this.id = data.id || null;
    this.name = data.name || '';
    this.type = data.type || ''; // 'map', 'poi', 'building', 'speedcam'
    this.fileName = data.fileName || '';
    this.filePath = data.filePath || '';
    this.fileSize = data.fileSize || 0;
    this.md5Hash = data.md5Hash || '';
    this.uploadedAt = data.uploadedAt || null;
    this.status = data.status || 'pending'; // 'pending', 'uploading', 'completed', 'failed'
    this.version = data.version || '1.0.0';
    this.region = data.region || 'Vietnam';
    this.metadata = data.metadata || {};
  }

  // Validate file before upload
  validate() {
    const errors = [];
    
    if (!this.fileName) {
      errors.push('File name is required');
    }
    
    if (!this.type) {
      errors.push('Data type is required');
    }
    
    if (this.fileSize <= 0) {
      errors.push('File size must be greater than 0');
    }
    
    if (!this.md5Hash) {
      errors.push('MD5 hash is required for integrity verification');
    }
    
    return {
      isValid: errors.length === 0,
      errors
    };
  }

  // Convert to API format
  toApiFormat() {
    return {
      name: this.name,
      type: this.type,
      fileName: this.fileName,
      fileSize: this.fileSize,
      md5Hash: this.md5Hash,
      version: this.version,
      region: this.region,
      metadata: this.metadata
    };
  }

  // Update status
  updateStatus(status) {
    this.status = status;
    if (status === 'completed') {
      this.uploadedAt = new Date().toISOString();
    }
  }

  // Get file info
  getFileInfo() {
    return {
      fileName: this.fileName,
      fileSize: this.fileSize,
      md5Hash: this.md5Hash,
      type: this.type,
      status: this.status
    };
  }
}

module.exports = MapData;
