#!/bin/bash

echo "========================================"
echo "   ZZMaps API Client - Auto Install"
echo "========================================"
echo

# Check if Node.js is installed
if ! command -v node &> /dev/null; then
    echo "ERROR: Node.js is not installed!"
    echo "Please install Node.js from https://nodejs.org"
    echo "Then run this script again."
    exit 1
fi

echo "Node.js is installed:"
node --version
echo

# Check if npm is installed
if ! command -v npm &> /dev/null; then
    echo "ERROR: npm is not installed!"
    echo "Please install npm with Node.js"
    exit 1
fi

echo "npm is installed:"
npm --version
echo

# Install dependencies
echo "Installing dependencies..."
npm install
if [ $? -ne 0 ]; then
    echo "ERROR: Failed to install dependencies!"
    exit 1
fi

echo
echo "Dependencies installed successfully!"
echo

# Create .env file if it doesn't exist
if [ ! -f .env ]; then
    echo "Creating .env file..."
    cp env.example .env
    echo
    echo "IMPORTANT: Please edit .env file with your API credentials!"
    echo
fi

# Run setup
echo "Running project setup..."
npm run setup
if [ $? -ne 0 ]; then
    echo "ERROR: Setup failed!"
    exit 1
fi

echo
echo "========================================"
echo "   Installation completed successfully!"
echo "========================================"
echo
echo "Available commands:"
echo "  npm start                    - Interactive menu"
echo "  npm run upload-current      - Upload current data"
echo "  npm run setup               - Setup project"
echo "  node scripts/demo.js        - Demo project"
echo
echo "Press any key to continue..."
read -n 1
