@echo off
echo ========================================
echo    ZZMaps API Client - Auto Install
echo ========================================
echo.

REM Check if Node.js is installed
node --version >nul 2>&1
if %errorlevel% neq 0 (
    echo ERROR: Node.js is not installed!
    echo Please install Node.js from https://nodejs.org
    echo Then run this script again.
    pause
    exit /b 1
)

echo Node.js is installed: 
node --version
echo.

REM Check if npm is installed
npm --version >nul 2>&1
if %errorlevel% neq 0 (
    echo ERROR: npm is not installed!
    echo Please install npm with Node.js
    pause
    exit /b 1
)

echo npm is installed:
npm --version
echo.

REM Install dependencies
echo Installing dependencies...
call npm install
if %errorlevel% neq 0 (
    echo ERROR: Failed to install dependencies!
    pause
    exit /b 1
)

echo.
echo Dependencies installed successfully!
echo.

REM Create .env file if it doesn't exist
if not exist .env (
    echo Creating .env file...
    copy env.example .env
    echo.
    echo IMPORTANT: Please edit .env file with your API credentials!
    echo.
)

REM Run setup
echo Running project setup...
call npm run setup
if %errorlevel% neq 0 (
    echo ERROR: Setup failed!
    pause
    exit /b 1
)

echo.
echo ========================================
echo    Installation completed successfully!
echo ========================================
echo.
echo Available commands:
echo   npm start                    - Interactive menu
echo   npm run upload-current      - Upload current data
echo   npm run setup               - Setup project
echo   node scripts/demo.js        - Demo project
echo.
echo Press any key to continue...
pause >nul
