#!/bin/bash

echo "========================================"
echo "   ZZMaps API Client - Ubuntu Install"
echo "========================================"
echo

# Check if running on Ubuntu
if ! command -v apt &> /dev/null; then
    echo "WARNING: This script is optimized for Ubuntu/Debian"
    echo "You may need to install Node.js manually"
    echo
fi

# Check if Node.js is installed
if ! command -v node &> /dev/null; then
    echo "Node.js not found. Installing..."
    
    # Update package list
    echo "Updating package list..."
    sudo apt update
    
    # Install Node.js and npm
    echo "Installing Node.js and npm..."
    sudo apt install -y nodejs npm
    
    # Check installation
    if ! command -v node &> /dev/null; then
        echo "ERROR: Failed to install Node.js!"
        echo "Please install manually: sudo apt install nodejs npm"
        exit 1
    fi
fi

echo "Node.js is installed:"
node --version
echo

# Check if npm is installed
if ! command -v npm &> /dev/null; then
    echo "ERROR: npm is not installed!"
    echo "Please install npm: sudo apt install npm"
    exit 1
fi

echo "npm is installed:"
npm --version
echo

# Install dependencies
echo "Installing dependencies..."
npm install
if [ $? -ne 0 ]; then
    echo "ERROR: Failed to install dependencies!"
    exit 1
fi

echo
echo "Dependencies installed successfully!"
echo

# Create .env file if it doesn't exist
if [ ! -f .env ]; then
    echo "Creating .env file..."
    cp env.example .env
    echo
    echo "IMPORTANT: Please edit .env file with your API credentials!"
    echo "You can edit it with: nano .env"
    echo
fi

# Run setup
echo "Running project setup..."
npm run setup
if [ $? -ne 0 ]; then
    echo "ERROR: Setup failed!"
    exit 1
fi

echo
echo "========================================"
echo "   Installation completed successfully!"
echo "========================================"
echo
echo "Available commands:"
echo "  npm start                    - Interactive menu"
echo "  npm run upload-current      - Upload current data"
echo "  npm run setup               - Setup project"
echo "  node scripts/demo.js        - Demo project"
echo
echo "To upload data:"
echo "  ./upload.sh"
echo
echo "To run interactive menu:"
echo "  ./run.sh"
echo
echo "Press any key to continue..."
read -n 1
