#!/bin/bash

echo "========================================"
echo "   ZZMaps API Client - Demo"
echo "========================================"
echo

# Check if Node.js is installed
if ! command -v node &> /dev/null; then
    echo "ERROR: Node.js is not installed!"
    echo "Please install Node.js from https://nodejs.org"
    exit 1
fi

echo "Node.js is installed:"
node --version
echo

# Check if dependencies are installed
if [ ! -d "node_modules" ]; then
    echo "Dependencies not installed. Running install..."
    ./install.sh
    if [ $? -ne 0 ]; then
        echo "ERROR: Installation failed!"
        exit 1
    fi
fi

echo
echo "Running demo..."
echo

# Run demo
node scripts/demo.js
if [ $? -ne 0 ]; then
    echo "ERROR: Demo failed!"
    exit 1
fi

echo
echo "========================================"
echo "   Demo completed successfully!"
echo "========================================"
echo
read -p "Press any key to continue..."
