@echo off
echo ========================================
echo    ZZMaps API Client - Demo
echo ========================================
echo.

REM Check if Node.js is installed
node --version >nul 2>&1
if %errorlevel% neq 0 (
    echo ERROR: Node.js is not installed!
    echo Please install Node.js from https://nodejs.org
    pause
    exit /b 1
)

echo Node.js is installed: 
node --version
echo.

REM Check if dependencies are installed
if not exist node_modules (
    echo Dependencies not installed. Running install...
    call install.bat
    if %errorlevel% neq 0 (
        echo ERROR: Installation failed!
        pause
        exit /b 1
    )
)

echo.
echo Running demo...
echo.

REM Run demo
call node scripts/demo.js
if %errorlevel% neq 0 (
    echo ERROR: Demo failed!
    pause
    exit /b 1
)

echo.
echo ========================================
echo    Demo completed successfully!
echo ========================================
echo.
echo Press any key to continue...
pause >nul
