# 🌐 Hướng dẫn sử dụng trên Shared Hosting

## 🎯 **Tại sao Shared Hosting hoàn hảo cho dự án này:**

- ✅ **Không cần quyền root** - Chỉ cần quyền user thường
- ✅ **Không cần VPS** - Chạy được trên shared hosting
- ✅ **Chi phí thấp** - Chỉ cần hosting cơ bản
- ✅ **Dễ quản lý** - Không cần cấu hình phức tạp

## 🚀 **Cài đặt trên Shared Hosting:**

### **Bước 1: Kiểm tra Node.js support**
```bash
# Kiểm tra Node.js có sẵn không
node --version

# Nếu chưa có, cài đặt
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs
```

### **Bước 2: Chạy script tự động**
```bash
# Cấp quyền thực thi
chmod +x shared-hosting.sh

# Chạy script cài đặt
./shared-hosting.sh
```

### **Bước 3: Cấu hình API credentials**
```bash
# Chỉnh sửa file .env
nano .env

# Nhập thông tin API
ZZMAPS_USERNAME=your_username
ZZMAPS_PASSWORD=your_password
ZZMAPS_API_KEY=your_api_key
```

## 🎮 **Sử dụng dự án:**

### **Upload dữ liệu:**
```bash
# Upload tất cả dữ liệu
./upload.sh

# Hoặc sử dụng npm
npm run upload-current
```

### **Menu tương tác:**
```bash
# Chạy menu chính
./run.sh

# Hoặc sử dụng npm
npm start
```

### **Demo dự án:**
```bash
# Xem thông tin dự án
./demo.sh

# Hoặc sử dụng npm
node scripts/demo.js
```

## 🔧 **Cấu hình cho Shared Hosting:**

### **1. Cài đặt Node.js:**
```bash
# Cài đặt Node.js 18.x (LTS)
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs

# Kiểm tra cài đặt
node --version  # Should be v18.x or higher
npm --version   # Should be v9.x or higher
```

### **2. Cấu hình npm:**
```bash
# Cấu hình npm để sử dụng thư mục user
mkdir ~/.npm-global
npm config set prefix '~/.npm-global'
echo 'export PATH=~/.npm-global/bin:$PATH' >> ~/.bashrc
source ~/.bashrc
```

### **3. Cấu hình firewall (nếu cần):**
```bash
# Mở port cho API (nếu cần)
sudo ufw allow 3000
sudo ufw allow 8080
```

## 📁 **Cấu trúc thư mục trên Shared Hosting:**

```
/home/username/
├── zzmaps-api-project/
│   ├── shared-hosting.sh       # Script cho shared hosting
│   ├── install-ubuntu.sh       # Script cho Ubuntu
│   ├── install.sh              # Script cài đặt chung
│   ├── run.sh                  # Menu chính
│   ├── upload.sh               # Upload dữ liệu
│   ├── demo.sh                 # Demo dự án
│   ├── src/                    # Mã nguồn
│   ├── scripts/                # Scripts
│   ├── config/                 # Cấu hình
│   ├── node_modules/           # Dependencies
│   └── .env                    # API credentials
└── export_maps_signs/          # Dữ liệu bản đồ
    ├── map/
    ├── poi/
    ├── building/
    └── speedcam/
```

## 🎯 **Lợi ích khi sử dụng Shared Hosting:**

### **1. Chi phí thấp:**
- Chỉ cần hosting cơ bản
- Không cần VPS đắt tiền
- Không cần quản lý server

### **2. Dễ sử dụng:**
- Không cần quyền root
- Không cần cấu hình phức tạp
- Hỗ trợ Node.js sẵn có

### **3. Bảo mật:**
- Hosting provider quản lý bảo mật
- Cập nhật tự động
- Backup định kỳ

## 🆘 **Troubleshooting trên Shared Hosting:**

### **Lỗi "Permission denied":**
```bash
# Cấp quyền thực thi
chmod +x *.sh

# Chạy với quyền user
./shared-hosting.sh
```

### **Lỗi "Node.js not found":**
```bash
# Cài đặt Node.js
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs

# Kiểm tra PATH
echo $PATH
which node
```

### **Lỗi "npm not found":**
```bash
# Cài đặt npm
sudo apt install npm

# Hoặc cài đặt Node.js (bao gồm npm)
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs
```

### **Lỗi "EACCES" khi cài đặt packages:**
```bash
# Cấu hình npm để sử dụng thư mục user
mkdir ~/.npm-global
npm config set prefix '~/.npm-global'
echo 'export PATH=~/.npm-global/bin:$PATH' >> ~/.bashrc
source ~/.bashrc
```

### **Lỗi "Command not found" sau khi cài đặt:**
```bash
# Reload bashrc
source ~/.bashrc

# Hoặc logout và login lại
exit
# Login lại
```

## 🚀 **Sau khi cài đặt xong:**

1. **Dữ liệu được upload** lên api.zzmaps.com
2. **Website api.zzmaps.com** có thể sử dụng dữ liệu
3. **Ứng dụng mobile** kết nối trực tiếp với API
4. **Không cần server riêng** để chạy ứng dụng

## 🎉 **Tóm tắt:**

- ✅ **Shared Hosting** hoàn hảo cho dự án này
- ✅ **Không cần quyền root** để chạy
- ✅ **Chi phí thấp** và dễ quản lý
- ✅ **Hiệu suất cao** và ổn định
- ✅ **Hỗ trợ Node.js** sẵn có

---

**🚀 BẮT ĐẦU NGAY: Chạy `./shared-hosting.sh` để cài đặt và upload dữ liệu!**
