# Hướng dẫn sử dụng nhanh

## Bước 1: Cài đặt

```bash
cd zzmaps-api-project
npm install
```

## Bước 2: Thiết lập dự án

```bash
npm run setup
```

Script này sẽ:
- Kiểm tra dữ liệu bản đồ trong thư mục cha
- Tạo các thư mục cần thiết
- Yêu cầu nhập thông tin API credentials
- Tạo file .env với thông tin cấu hình

## Bước 3: Upload dữ liệu

```bash
# Upload tất cả dữ liệu
npm run upload-current

# Hoặc sử dụng menu tương tác
npm start
```

## Các lệnh hữu ích

```bash
# Menu tương tác
npm start

# Upload dữ liệu hiện tại
npm run upload-current

# Quản lý đồng bộ
node scripts/sync-data.js status
node scripts/sync-data.js incremental

# Quản lý file
node scripts/upload-data.js list
node scripts/upload-data.js delete <file_id>
```

## Cấu hình API

Chỉnh sửa file `.env`:

```bash
ZZMAPS_USERNAME=your_username
ZZMAPS_PASSWORD=your_password
ZZMAPS_API_KEY=your_api_key
```

## Xử lý lỗi

### Lỗi xác thực
- Kiểm tra thông tin đăng nhập trong file .env
- Đảm bảo API key hợp lệ

### Lỗi upload
- Kiểm tra kết nối mạng
- Kiểm tra quyền truy cập API
- Kiểm tra kích thước file (max 500MB)

### Lỗi cấu hình
- Chạy lại `npm run setup`
- Kiểm tra file .env có đúng format không

## Cấu trúc dữ liệu

Dự án mong đợi cấu trúc thư mục sau:

```
export_maps_signs/
├── map/           # Dữ liệu bản đồ
├── poi/           # Points of Interest
├── building/      # Dữ liệu 3D buildings
├── speedcam/      # Camera tốc độ
└── zzmaps-api-project/  # Dự án API client
```

## Hỗ trợ

Nếu gặp vấn đề, kiểm tra:
1. File .env có đúng thông tin không
2. Kết nối mạng có ổn định không
3. API zzmaps.com có hoạt động không
4. File dữ liệu có bị hỏng không

