# Hướng dẫn cài đặt và sử dụng

## Yêu cầu hệ thống

- Node.js >= 14.0.0
- npm >= 6.0.0
- Quyền truy cập API zzmaps.com
- Dữ liệu bản đồ Việt Nam (đã có sẵn trong thư mục)

## Cài đặt

### 1. Cài đặt dependencies

```bash
cd zzmaps-api-project
npm install
```

### 2. Thiết lập dự án

```bash
npm run setup
```

Script này sẽ:
- Kiểm tra dữ liệu bản đồ trong thư mục cha
- Tạo các thư mục cần thiết
- Yêu cầu nhập thông tin API credentials
- Tạo file .env với thông tin cấu hình

### 3. Cấu hình API credentials

Chỉnh sửa file `.env`:

```bash
ZZMAPS_USERNAME=your_username
ZZMAPS_PASSWORD=your_password
ZZMAPS_API_KEY=your_api_key
```

## Sử dụng

### Upload dữ liệu

```bash
# Upload tất cả dữ liệu
npm run upload-current

# Menu tương tác
npm start

# Upload file đơn lẻ
node scripts/upload-data.js file /path/to/file.fbl

# Upload với tùy chọn
node scripts/upload-data.js file /path/to/file.poi -n "Vietnam POI" -t poi -v 1.0.0
```

### Quản lý đồng bộ

```bash
# Đồng bộ đầy đủ
node scripts/sync-data.js full

# Đồng bộ tăng dần (chỉ file mới/thay đổi)
node scripts/sync-data.js incremental

# Xem trạng thái đồng bộ
node scripts/sync-data.js status

# Reset trạng thái đồng bộ
node scripts/sync-data.js reset
```

### Quản lý file

```bash
# Liệt kê file đã upload
node scripts/upload-data.js list

# Liệt kê theo loại
node scripts/upload-data.js list -t map

# Xóa file
node scripts/upload-data.js delete <file_id>
```

## Cấu trúc dự án

```
zzmaps-api-project/
├── src/
│   ├── models/              # Data models
│   │   └── MapData.js       # Map data model
│   ├── services/            # Business logic
│   │   ├── AuthService.js   # Authentication
│   │   ├── UploadService.js # File upload
│   │   └── DataSyncService.js # Data synchronization
│   └── index.js             # Main application
├── scripts/
│   ├── setup.js             # Project setup
│   ├── upload-data.js       # File upload management
│   ├── sync-data.js         # Data synchronization
│   └── upload-current-data.js # Upload current data
├── config/
│   ├── config.js            # Main configuration
│   └── config-local.js      # Local configuration
├── temp/                    # Temporary files
├── backup/                  # Backup files
├── logs/                    # Log files
├── package.json
├── README.md
├── QUICKSTART.md
└── INSTALLATION.md
```

## Cấu hình

### API Settings

```javascript
// config/config.js
const config = {
  api: {
    baseUrl: 'https://api.zzmaps.com',
    version: 'v1',
    timeout: 30000,
    retryAttempts: 3
  }
};
```

### Upload Settings

```javascript
upload: {
  chunkSize: 1024 * 1024,        // 1MB chunks
  maxConcurrentUploads: 3,        // Max 3 concurrent uploads
  supportedFormats: ['.fbl', '.fjv', '.fpa', '.fda', '.poi', '.3dc', '.3dl', '.spc', '.spud'],
  maxFileSize: 500 * 1024 * 1024  // 500MB max file size
}
```

## Định dạng file hỗ trợ

- **Map Data**: `.fbl`, `.fjv`, `.fpa`, `.fda`
- **POI Data**: `.poi`
- **Building Data**: `.3dc`, `.3dl`
- **Speed Camera**: `.spc`, `.spud`

## Xử lý lỗi

### Lỗi xác thực
```bash
# Kiểm tra credentials
echo $ZZMAPS_USERNAME
echo $ZZMAPS_PASSWORD
echo $ZZMAPS_API_KEY
```

### Lỗi upload
```bash
# Kiểm tra kết nối
curl -I https://api.zzmaps.com

# Kiểm tra file
ls -la /path/to/your/file
```

### Lỗi cấu hình
```bash
# Kiểm tra cấu hình
node -e "console.log(require('./config/config'))"
```

## Logging

Logs được lưu trong thư mục `logs/` với các mức độ:
- `info`: Thông tin chung
- `warn`: Cảnh báo
- `error`: Lỗi

## Troubleshooting

### 1. Lỗi "No map data directories found"
- Đảm bảo chạy script từ thư mục `zzmaps-api-project`
- Kiểm tra thư mục cha có chứa dữ liệu bản đồ

### 2. Lỗi "Authentication failed"
- Kiểm tra thông tin đăng nhập trong file .env
- Đảm bảo API key hợp lệ
- Kiểm tra kết nối mạng

### 3. Lỗi "Upload failed"
- Kiểm tra kích thước file (max 500MB)
- Kiểm tra định dạng file có được hỗ trợ không
- Kiểm tra quyền truy cập API

### 4. Lỗi "File already exists"
- File đã tồn tại trên server
- Sử dụng `--force` để upload lại
- Hoặc xóa file cũ trước khi upload

## Hỗ trợ

Nếu gặp vấn đề:
1. Kiểm tra file .env có đúng thông tin không
2. Kiểm tra kết nối mạng có ổn định không
3. Kiểm tra API zzmaps.com có hoạt động không
4. Kiểm tra file dữ liệu có bị hỏng không
5. Xem logs trong thư mục `logs/`

## License

MIT License - xem file LICENSE để biết thêm chi tiết.
