# 📥 Hướng dẫn cài đặt Node.js

## 🎯 **Tại sao cần Node.js?**
- Node.js là môi trường chạy JavaScript
- Dự án này được viết bằng JavaScript
- **KHÔNG cần quyền SSH** để cài đặt
- **KHÔNG cần VPS** để chạy

## 🖥️ **Cài đặt trên Windows:**

### **Cách 1: Tải từ trang chủ (Khuyến nghị)**
1. Truy cập: https://nodejs.org
2. Tải phiên bản **LTS** (Long Term Support)
3. Chạy file `.msi` vừa tải
4. Làm theo hướng dẫn cài đặt
5. Khởi động lại máy tính

### **Cách 2: Sử dụng Chocolatey**
```bash
# Cài đặt Chocolatey trước (nếu chưa có)
# Sau đó chạy:
choco install nodejs
```

### **Cách 3: Sử dụng Winget**
```bash
winget install OpenJS.NodeJS
```

## 🍎 **Cài đặt trên Mac:**

### **Cách 1: Tải từ trang chủ**
1. Truy cập: https://nodejs.org
2. Tải phiên bản **LTS**
3. Chạy file `.pkg` vừa tải
4. Làm theo hướng dẫn cài đặt

### **Cách 2: Sử dụng Homebrew**
```bash
# Cài đặt Homebrew trước (nếu chưa có)
# Sau đó chạy:
brew install node
```

### **Cách 3: Sử dụng NVM**
```bash
# Cài đặt NVM
curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.39.0/install.sh | bash

# Cài đặt Node.js
nvm install 18
nvm use 18
```

## 🐧 **Cài đặt trên Linux:**

### **Ubuntu/Debian:**
```bash
# Cập nhật package list
sudo apt update

# Cài đặt Node.js
sudo apt install nodejs npm

# Kiểm tra phiên bản
node --version
npm --version
```

### **CentOS/RHEL:**
```bash
# Cài đặt Node.js
sudo yum install nodejs npm

# Hoặc sử dụng dnf
sudo dnf install nodejs npm
```

### **Arch Linux:**
```bash
sudo pacman -S nodejs npm
```

## ✅ **Kiểm tra cài đặt:**

Mở Command Prompt (Windows) hoặc Terminal (Mac/Linux) và chạy:

```bash
node --version
npm --version
```

Nếu hiển thị số phiên bản thì đã cài đặt thành công!

## 🚀 **Sau khi cài đặt Node.js:**

1. **Mở Command Prompt/Terminal**
2. **Di chuyển đến thư mục dự án:**
   ```bash
   cd /path/to/zzmaps-api-project
   ```
3. **Chạy script tự động:**
   ```bash
   # Windows
   install.bat
   
   # Mac/Linux
   chmod +x *.sh
   ./install.sh
   ```

## 🆘 **Troubleshooting:**

### **Lỗi "node is not recognized" (Windows):**
- Khởi động lại máy tính
- Kiểm tra PATH environment variable
- Cài đặt lại Node.js

### **Lỗi "command not found" (Mac/Linux):**
- Kiểm tra PATH trong ~/.bashrc hoặc ~/.zshrc
- Chạy `source ~/.bashrc` hoặc `source ~/.zshrc`
- Cài đặt lại Node.js

### **Lỗi "permission denied":**
- Sử dụng `sudo` (Linux/Mac)
- Chạy với quyền Administrator (Windows)

## 📱 **Sau khi cài đặt xong:**

- Dự án sẽ tự động cài đặt dependencies
- Tự động tạo file cấu hình
- Tự động upload dữ liệu bản đồ
- **KHÔNG cần VPS** hay quyền SSH

---

**💡 Lưu ý: Node.js bao gồm cả npm, nên chỉ cần cài Node.js là đủ!**
